/**
 *
 * \file        hprfgw_rfDesc.h
 *
 * \brief       RF Descriptor entry functions declarations and definitions
 *
 * \detial      
 * \author      Hazrat Shah	
 *
 * \date        08/24/2006
 * \warning		
 * \note
 * \review	
 *
 */
#ifndef _HPRFGW_RFDESC_H_
	#define _HPRFGW_RFDESC_H_

#include "hprfgw_config.h"

// MNT - 3/19/2007 - Dependency Removal tag begin
//#include "network.h"
#include "hprfgw_rfSharedDefs.h"
// MNT - 3/19/2007 - Dependency Removal tag end
#include "hprfgw_rfPkt.h"
#include "hprfgw_rfRec.h"
//#include "hprfgw_rftrans.h"

////////////////////////////////////////////////////////////////////////////////
//	Definitions
////////////////////////////////////////////////////////////////////////////////
//#define	RF_NETWORK_MASTER_DEVICE							//	Define if compiling for network master device (gateway)	 
//#undef	RF_NETWORK_MASTER_DEVICE							//	Undefine if compiling for network slave device (eg. TPS6) 

#define	RF_LINK_HISTORY_LOG
#define	RF_INVALID_RX_PACKET_LOG
//#define RF_MSG_ERR_LOG

#ifdef	RF_NETWORK_MASTER_DEVICE
	#define	DEFAULT_RF_NETWORK_SUPPORTED_DEVICES	16 
	#define	MAX_RF_NETWORK_SUPPORTED_DEVICES 		252
	//	1..252-entries for rf devices
	//	1-entry for network services entry
	//	1-entry for MLME packets
	//	1-entry for ASP packets									
	#define	MAX_DESCRIPTIVE_TABLE_ENTRIES			255			//	Consists of entries for RF Devices, ASP packet and MLME packet
#else
	#define	DEFAULT_RF_NETWORK_SUPPORTED_DEVICES	1			
	#define	MAX_RF_NETWORK_SUPPORTED_DEVICES 		1			
	//	1-entry for rf device
	//	1-entry for network services entry
	//	1-entry for MLME packets
	//	1-entry for ASP packets				
	#define	MAX_DESCRIPTIVE_TABLE_ENTRIES			4			//	Consists of entries for gateway, ASP packet and MLME packet
	#define	MAX_ROAMING_DESCRIPTIVE_TABLE_ENTRIES	8           // to save all raoming gateway, up to 8 for now
#endif

//	Gateway descriptieve table index for slave devices only (NOT FOR TO BE USED IN MASTER or Gateway mode)
#define	DEVICE_DESCRIPTIVE_TABLE_INDEX				0	

//	Possible RF Device link states
#define	RF_DEVICE_LINK_STATE_EMPTY					0		//	link state in gateway and in device
#define	RF_DEVICE_LINK_STATE_TEMP_CONN_ACCESS 		1		//	link state in gateway and in device
#define	RF_DEVICE_LINK_STATE_ACTIVE					2		//	link state in gateway and in device
#define	RF_DEVICE_LINK_STATE_FAIL					3		//	link state in gateway and in device
#define	RF_DEVICE_LINK_STATE_SLEEP					4		//	link state in gateway and in device
#define	RF_DEVICE_LINK_STATE_DISCONNECTED			5		//	link state in gateway 
#define	RF_DEVICE_LINK_STATE_POWERDOWN				6		//	link state in gateway 
#define	RF_DEVICE_LINK_STATE_CONNECTING				7		//	reserved link state in devices only	

//	rf packet max size
#define	RF_DEVICE_MAX_PAYLOAD_SECURITY_DISABLED		100
#define	RF_DEVICE_MAX_PAYLOAD_SECURITY_ENABLED		80
#define	RF_DEVICE_TRANSMIT_BUFFER_SIZE				(RF_DEVICE_MAX_PAYLOAD_SECURITY_DISABLED-sizeof(TYPE_RF_PAYLOAD_HEADER))	
#define	RF_DEVICE_DATA_HOLD_BUFFER_SIZE				(RFS_CNET_MAX_MSG_SIZE+1)	
#define RF_DEVICE_PIPE_MAX_MSG_LEN					(RF_DEVICE_DATA_HOLD_BUFFER_SIZE+sizeof(TYPE_RF_DEVICE_RFTX_INTERNAL_HDR))	

#define	RF_DEVICE_LINK_QUALITY_HYSTERISES			655		//	rf device link quality hysterisas threshold
#ifndef	RF_NETWORK_MASTER_DEVICE
#define	RF_GW_LQ_BUFFER_SIZE                        RF_DEVICE_DATA_HOLD_BUFFER_SIZE-1 
#define GW_RM_MAX_MV_AV_FILTER_SZ                   10
#endif
////////////////////////////////////uid////////////////////////////////////////////
//	Variable prototypes 
////////////////////////////////////////////////////////////////////////////////
typedef	struct	{
	UINT8	uid[UID_MAX_SIZE]; 					//	remote device unique identifier
	UINT16	panid;								//	remote device panid 
	UINT8	addrmode;							//	remote device addressing mode (16-bit, 64-bit)
	UINT8	rfid;								//	remote device rfid used in cresnet frames
	UINT32	tsid;								//	
	UINT16	power;								//	remote device rf power level 
	INT8	idstring[RF_DEVICE_MAX_CRESNET_ID_STRING_LEN+1];//	device id string 	
	UINT16	deviceoptions;						//	remote device option flags ((AC/battery operated, traffic type etc..) 
}	TYPE_RF_DEVICE_ID_INFO;			

#ifdef	RF_MSG_ERR_LOG
	#define	RF_DEVICE_MAX_MSG_ERRORS	100
	typedef	struct	{
		UINT8	type;								//	MCP, ASP, MLME
		UINT8	subtype;							//	
		UINT8	req;								//	
		UINT8	initiator;							//	MSG_Send, MSG Confirm, etc...
		UINT8	code;								//	Error Status code
	}	TYPE_RF_DEVICE_ERR;				
	typedef	struct	{
		TYPE_RF_DEVICE_ERR Err[RF_DEVICE_MAX_MSG_ERRORS];
		UINT16	in;
		UINT16	out;	
	}	TYPE_RF_DEVICE_MSG_ERR;		
#endif

#ifdef	RF_LINK_HISTORY_LOG
	#define	MAX_LINK_TRANSITION_HISTORY_LOG	20
	typedef	struct	{
		UINT32	time;
		UINT8	state;	
		UINT8	reason;
	}	TYPE_RF_DEVICE_LINK_HISTORY;	
#endif

#ifdef	RF_INVALID_RX_PACKET_LOG
	#define	MAX_INVALID_RX_PACKET_LOG	10
	typedef	struct	{
		struct	{
			mcpsDataInd_t hdr;	
			UINT8	data[RF_DEVICE_TRANSMIT_BUFFER_SIZE+10];
			UINT8	datalen;
		}	packet[MAX_INVALID_RX_PACKET_LOG];
		UINT8	packetindex;
		UINT8	packetcnt;
	}	TYPE_RF_DEVICE_INVALID_PACKET_LOG; 	
#endif

typedef	struct	{
	BOOL	txbufoverflowflag;					//	transmit buffer overflow occured if set	 			
	UINT32	txbufoverflowcount;					//	number of times the transmiter buffer overflow occured  
											
	BOOL	rxbufoverflowflag;					//	receiver buffer overflow occured if set 
	UINT32	rxbufoverflowcount;					//	number of times the receiver buffer overflow occured

	UINT32	txpacketcount;						//	total number of transmitted packets to RF Device
	UINT32	rxpacketcount;						//	total number of received packets from RF Device
	UINT32	txpacketconcatcount;				//	total number of concatenated transmitted packets to RF Device
	UINT32	rxpacketconcatcount;				//	total number of concatenated received packets from RF Device

	UINT32	rxpacketpayloadbytecount;			//	total number of payload data bytes received 
	UINT32	txpacketfailcount;					//	total number of packets that could not be sent to the RF Device
	UINT32  txpacketerrorcount;					//	total number of packets that counld not be transmited due error code returned by stack

	UINT32	rxpacketrepeatcount;				//	total number of repeat packets received from the Rf Device
	UINT32	rxpacketsequenceErrcount;			//	rf device frame sequence error count
	UINT32	rxpacketlenerror;					//	rf received packet length error (invalid packet length, too small or too large)
	UINT32  rxpackethdrftrerror;				//	rf received packets with hdr/footer error

	UINT32	rxpacketacks;						//	total number of acks received	
	UINT32	rxpacketnaks;						//	total number of naks received 

	UINT32	txpacketpayloadbytecount;			//	total number of payload data bytes transmitted
	UINT32	txpacketoverheadbytecount;			//	total number of overhead data bytes transmitted or received as an ACK for transmission packets
	UINT32	txpacketsamplestarttime;			//	packet count sample start time 

	UINT32	txpacketfailsincelastactivelinkcnt;	//		
	UINT32	txpacketretrycount;					//	total number of packet transmission retries 	
	UINT32	txpacketresultcodetimeouts;			//	total number of result code timeouts

	UINT32	txpacketposttime;					//	packet transmission posting time
	UINT32	txpacketturnaroundtime;				//	time logged when low level ack is received (can be used to measure net congestion) 
	UINT32	txpacketaccturnaroundtime;			//	accumalative turn around logged time  

	UINT32	rxpacketsegmentationerrcnt;			//	total number of errors in received packet segments
	
	UINT32	heartbeattimeouts;					//	total heart beat timeouts
	
	UINT32	rxgwrestarts;						//	total number of gw restart messages

	UINT32	rxpacketsegmented;					//	total number of segmented packets received 
	UINT32	rxpacketinvalidcmd;					//	total number of received packets with invalid cmds  

#ifdef	MSG_ERR_LOG
	TYPE_RF_DEVICE_MSG_ERR	MsgErr;				//	rf stack msg send, msg confirmation errors
#endif

	UINT32	txpacketsegmented;					//	total number of segmented transmit packet 

	UINT32	rxpacketremotecfg;					//	total number of remote setup packets  

#ifdef	RF_LINK_HISTORY_LOG
	TYPE_RF_DEVICE_LINK_HISTORY LinkStateHistory[MAX_LINK_TRANSITION_HISTORY_LOG];		
	UINT32	linkstatelogindex;	
#endif
#ifdef	RF_INVALID_RX_PACKET_LOG
	TYPE_RF_DEVICE_INVALID_PACKET_LOG InvalidPktLog;
#endif

	UINT32	txpacketcongavoidance;				//

}	TYPE_RF_DEVICE_COM_LOG;				

typedef	struct {
	INT32	(*pf) (UINT32 par, UINT32 status);
	UINT32  par;
	UINT32	timetolivestart;
	UINT32	timetolive;
	UINT32	index;
}	TYPE_RFSTACK_CB;

//	RF Device internal header, set when posting a packet to the rf transmit task 
typedef	struct	{
	UINT8	type;								//	primary type 	
	UINT8	subtype;							//	sub-type	
	UINT8	req;								//	requester
	UINT8	hdroptions1;						//	frame transmit options (ack, noack, broadcast, unicast, priority etc...)
	UINT8	hdroptions2; 						//	unused	
	UINT16	unused;								//	unused
	TYPE_RFSTACK_CB cb;							//	call back function
}	TYPE_RF_DEVICE_RFTX_INTERNAL_HDR;

typedef	struct	{
	//	Queued message with header and data
	TYPE_RF_DEVICE_RFTX_INTERNAL_HDR inthdr;	//	Internal RF packet header	  	
	UINT8	data[RF_DEVICE_DATA_HOLD_BUFFER_SIZE];	
	
	//	Message in process parameters 
	UINT32	len;								//	data hold buffer length
	UINT16	index;								//	index into the data hold buffer
	UINT8	totalsegment;						//	total segments of the data hold buffer 
	UINT8	segmentno;  						//	segment number of the data hold buffer	
}	TYPE_RF_DEVICE_RF_DATA_HOLD_BUF;

typedef	struct	{
	TYPE_RF_PAYLOAD_HEADER hdr;  				 //	transmit payload header	(there is a single header per payload)
	UINT8	data[RF_DEVICE_TRANSMIT_BUFFER_SIZE];//	transmit payload data buffer			
}	TYPE_RF_TRANSMIT_PAYLOAD_BUF;				

#define	RF_TRANSMIT_BUF_MAX_NO_OF_CBS			30
typedef	struct	{
	TYPE_RF_DEVICE_RFTX_INTERNAL_HDR inthdr;	//	Internal header 	
	TYPE_RF_TRANSMIT_PAYLOAD_BUF payld;			//	RF transmit payload buffer		 
	UINT8	len;								//	transmit payload data buffer length
	UINT8	index;								//	index into the transmit payload data buffer
	//	call backs per tx packets, one transmit payload packet may contain multiple smaller 
	//	concatenated packets. A separate call back handler must be maintained for each sub-packet 	
	TYPE_RFSTACK_CB txcb[RF_TRANSMIT_BUF_MAX_NO_OF_CBS];	  	
}	TYPE_RF_DEVICE_RF_TRANSMIT_BUF;

typedef	struct	{
	TYPE_RF_DEVICE_RF_TRANSMIT_BUF	Transmit;
	TYPE_RF_DEVICE_RF_DATA_HOLD_BUF	DataHold;
}	TYPE_RF_DEVICE_RFTX_BUF;
   
typedef	struct	{
	TYPE_RF_PAYLOAD_HEADER payldhdr; 				//	receive payload header
	TYPE_INTERNAL_RF_PACKET_HEADER pkthdr;			//	receive packet header	
	UINT8	data[RF_DEVICE_DATA_HOLD_BUFFER_SIZE];  //	packet data 

	UINT16	index;								//	index into the data hold buffer
	UINT8	segmenterror;						//	error occured during packet de-segmentation
}	TYPE_RF_DEVICE_RFRX_BUF;

typedef	struct	{
	UINT8	linkqualityAtLocalDevice;			//	link quality level at gateway measured with last device packet
	UINT8	linkqualityAtRemoteDevice;			//	link quality level at device measured on the device side on gateway packets
}	TYPE_RF_DEVICE_LINKQUALITY_REPORTED;		//

#define	RF_DEVICE_INFO_MAX_FIELDS				17	//	maximum fields 
	#define	RF_DEVICE_INFO_MAX_DATA_FIELD_INDEX	15	//	data fields 0...15
	#define	RF_DEVICE_INFO_CRC_FIELD_INDEX		16	//	crc field 16 
	#define RF_DEVICE_INFO_MAX_DATA_FIELDS		(RF_DEVICE_INFO_MAX_DATA_FIELD_INDEX+1)
typedef	struct	{
	INT8	data[RF_DEVICE_DATA_FIELD_MAX_SIZE];	
	UINT16	len;
	UINT16	crc;
}	TYPE_RF_DEVICE_INFO_FIELD;			

typedef	struct	{
	TYPE_RF_DEVICE_INFO_FIELD field[RF_DEVICE_INFO_MAX_FIELDS];
}	TYPE_RF_DEVICE_INFO_REC;			

typedef	struct	{
	UINT8	uid[UID_MAX_SIZE];					//	source UID				
	UINT16	panid;								//	source PANID
	UINT8	sequence;							//	received broadcast packet sequence number
}	TYPE_RF_DEVICE_BROADCAST_RXSEQ;			

typedef	struct	{
	TYPE_RF_DEVICE_BROADCAST_RXSEQ rx[MAX_RF_NETWORK_SUPPORTED_DEVICES];	//	
	UINT8	txsequence;							//	transmitted broadcast packet sequence number
}	TYPE_RF_DEVICE_BROADCAST_SEQ_REC;			
extern TYPE_RF_DEVICE_BROADCAST_SEQ_REC BDR;

typedef	struct	{
	TYPE_RF_DEVICE_ID_INFO	IDInfo;				//	rf device id information
		
	UINT8	linkstate;							//	current link state (not connected, active, partial, fail, sleep)
	UINT32	linkstatecnt;						//	counts number of link state changes from active state to partial state
	
	UINT32	linkeactiveestablishedtime;			//	time when active link was established (derived from real time clock)
	INT16	linkeactiveestablishedday;		 
	INT16	linkeactiveestablishedmonth;	 
	INT16	linkeactiveestablishedyear;	

	TYPE_RF_DEVICE_LINKQUALITY_REPORTED LQ;	

	UINT8	txsequence;							//	transmitting frame sequence count
	UINT8	rxsequence;							//	receiving frame sequence count
	
	UINT16	txpacketretrycntr;					//	transmit packet retry count counter, reset after successful transmission
	UINT16	maxtxpacketretries;					//	maximum transmit packet retries 

	TYPE_RF_DEVICE_COM_LOG  COMLog;				//	communication log parameters

#if defined (OS_NUCLEUS)
	NU_PIPE pipe;								//	pipe control block
	UINT8	*ppipebuf;							//	pointer to pipe memory block	
#elif defined (OS_WINCE)
	HANDLE  QueueReadHandle;
	HANDLE  QueueWriteHandle;
#elif defined (OS_LINUX)
	DM_RESOURCE_HANDLE QueueHandle;
#endif

	TYPE_RF_DEVICE_RFTX_BUF	TxBuf;				//	transmit data buffer 
	
	UINT8	waitingforACK; 						//	device is waiting for ACK/NAK etc if set  	
	UINT8	resultcodeavailable; 				//	device's result code is avaliable if set 	
	UINT8	resultcode;							//	device's result code
	
	UINT16	RetryTimer;					
	UINT8	RetryTimedOut;				
	
	UINT16	HeartBeatTimer;				
	UINT8	HeartBeatTimedOut;			
	
    UINT16	ResultCodeTimer;			
	UINT8	ResultCodeTimedOut;			
	
	TYPE_RF_DEVICE_RFRX_BUF	RxBuf;				//	receiver data buffer	
	
	TYPE_RF_DEVICE_INFO_REC DevField;			//	device info fields

}	TYPE_RF_DESCRIPTIVE_TABLE;

typedef	struct	{
	UINT32	SMACResetCntr;						//	counts All SMAC resets by app/net
	UINT32	NoDevConnSMACResetCntr;				//	counts SMAC resets by app/net when no device(s) are connected 

}	TYPE_RF_MSTAT_PARS;

extern TYPE_RF_MSTAT_PARS gMStatp;
extern TYPE_RF_DESCRIPTIVE_TABLE* g_pRFDeviceDescriptiveTable;
extern UINT8   g_MaxSupportedRFDevices;
extern UINT8   g_MaxDescriptiveTableEntries;	
extern UINT8   g_roamingEnabled ;
#ifndef	RF_NETWORK_MASTER_DEVICE
extern TYPE_RF_DESCRIPTIVE_TABLE* g_pRFRoamingDescriptiveTable;
extern INT8    g_acquireSlot ;
#endif
////////////////////////////////////////////////////////////////////////////////
//	Function declaractions	
////////////////////////////////////////////////////////////////////////////////
#ifdef  __cplusplus
extern "C" 
{
#endif

extern	void    RFDesc_Init (void);

extern	UINT16 	RFDesc_GetActiveRFDeviceTableIndexByRFID (UINT8 RFID, UINT8 *pIndex);

extern	UINT16	RFDesc_GetIndexToDescriptiveTableByRFID (UINT8 rfid, UINT8 *pindextable);
extern	UINT16	RFDesc_GetIndexToDescriptiveTableByTSID (UINT32 tsid, UINT8 *pindextable);
extern  UINT16	RFDesc_GetIndexToDescriptiveTableByTSIDWithGivenLinkState (UINT32 tsid, UINT8 *pindextable, UINT8 linkstate);
extern	UINT16	RFDesc_GetIndexToDescriptiveTableByUID (UINT8 *puid, UINT8 *pindextable);
extern	UINT16	RFDesc_GetIndexToDescriptiveTableByUIDWithGivenLinkState (UINT8 *puid, UINT8 *pindextable, UINT8 linkstate);
extern  UINT16  RFDesc_GetIndexToDescriptiveTableAllDevices (UINT8 *pindextable);
extern  UINT16  RFDesc_GetIndexToDescriptiveTableAllDevicesWithGivenLinkState (UINT8 *pindextable, UINT8 linkstate);

extern	UINT16 	RFDesc_UpdateLinkQualityAtGateway (UINT8 index, UINT8 linkquality);
extern	UINT16 	RFDesc_UpdateLinkQualityAtDevice (UINT8 index, UINT8 linkquality);

extern	UINT8 	RFDesc_GetMLMEDescriptiveTableIndex (void);
extern	UINT8 	RFDesc_GetASPDescriptiveTableIndex (void);

extern	UINT16	RFDesc_IsDuplicateUID(UINT8 index, UINT32 tsid);

extern	void	RFDesc_LinkStateTransition (UINT8 index, UINT8 LinkState);
extern	BOOL	RFDesc_IsLocalDeviceInAcquire (void);
extern	void	RFDesc_UpdateDeviceIDInfo(UINT8 index, UINT8 power, UINT32 tsid, UINT8 rfid, UINT16 panid, UINT8 options, UINT8 *pidstr, UINT8 idstrlen);

extern	void	RFDesc_UpdateDeviceIDStr (UINT8 index, UINT8 *pidstr, UINT8 idstrlen);
extern	UINT16  RFDesc_CreateEntryInDescriptiveTable (UINT8 *pdsindex, UINT8 *puid, UINT16 panid, UINT8 addrmode, UINT8 rxsequence);
extern	void	RFDesc_BuildActiveRFDeviceTableIndexByRFID (void);

extern	void	RFDesc_SetUID (UINT8 index, UINT8 *puid);
extern	void	RFDesc_SetPanID (UINT8 index, UINT16 PanID);		
extern	void	RFDesc_SetAddrMode (UINT8 index, UINT8 addrmode);
extern	BOOL	RFDesc_IsDescEntriesCreated (void);
extern	TYPE_RF_DESCRIPTIVE_TABLE *RFDesc_GetDescriptiveEntryIDInfo (UINT8 index);
extern	UINT8	RFDesc_MaxSupportedDescriptiveEntries (void);

extern	UINT16	RFDesc_UpdateLinkQualityOfRemoteDevice (UINT8 index, UINT8 linkquality);
extern	UINT16	RFDesc_UpdateLinkQualityOfLocalDevice (UINT8 index, UINT8 linkquality);
extern	UINT16	RFDesc_GetLinkQualityOfLocalDevice (UINT8 index, UINT8 *plinkquality);
extern	UINT16	RFDesc_GetLinkQualityOfRemoteDevice (UINT8 index, UINT8 *plinkquality);
extern  UINT16  RFDesc_GetLinkQualityOfLocalDeviceByRFID (UINT8 rfid, UINT8 *plinkquality);
extern  UINT16  RFDesc_GetLinkQualityOfRemoteDeviceByRFID (UINT8 rfid, UINT8 *plinkquality);
extern	INT8    *ConvertUIDtoString (UINT8 *puid, INT8 *pstr, UINT8 addrmode);
extern  UINT16	RFDesc_SetSlaveDeviceLinkEstablishedParameters(UINT8 index);
extern  UINT16  RFDesc_GetSlaveDeviceInfoField (UINT8 index, UINT8 field, INT8 *pbuf, UINT16 *plen, UINT16 *pcrc);
extern  UINT16  RFDesc_SetSlaveDeviceInfoField (UINT8 index, UINT8 field, INT8 *pbuf, UINT16 len, UINT16 crc);
extern	INT8	*ConvertLinkStatetoString (UINT8 linkstate, INT8 *pbuf);
extern	UINT8 	RFDesc_GetNetworkServicesDescriptiveTableIndex (void);
extern	UINT16  RFDesc_InitEntryInDescriptiveTable (UINT8 index, UINT8 *puid, UINT16 panid, UINT8 addrmode, UINT8 rxsequence, UINT8 linkstate);
extern	UINT16  RFDesc_GetNetworkServiceDescriptiveTableEntryByUID (UINT8 *pdsindex, UINT8 *puid, UINT16 panid, UINT8 addrmode);
extern	UINT16  RFDesc_CreateNetworkServiceDescriptiveTableEntryByUID (UINT8 *pdsindex, UINT8 *puid, UINT16 panid, UINT8 addrmode, UINT8 rxsequence);
extern	UINT16	RFDesc_GetDeviceLinkStateByRFID (UINT8 rfid, UINT8 *plinkstate);		
extern	UINT16  RFDesc_SortIndexElementsByRFID (UINT8* pindextbl, UINT8 count);
extern	INT32	RFDesc_FindBroadcastDeviceUID (UINT8 *index, UINT8 *puid, UINT16 panid);	
extern	INT32	RFDesc_AddBroadcastDeviceUID (UINT8 *index, UINT8 *puid, UINT16 panid, UINT8 seqno);	
#ifdef	RF_NETWORK_MASTER_DEVICE
extern  INT32	RFDesc_DeleteBroadcastDeviceUID (UINT8 *puid, UINT16 panid)	;
#endif

#ifdef	RF_LINK_HISTORY_LOG
	extern	INT32	RFDesc_LogLinkTransition (UINT8 index, UINT8 linkstate);
	extern	INT32	RFDesc_GetIndexofCurrentLinkTransition (UINT8 index, UINT8 *plinkstatetransition, UINT8 *plinkstatemaxentries);
	extern	INT32	RFDesc_GetLinkTransitionLogAtIndex (UINT8 index, UINT8 *plinkstateindex, TYPE_RF_DEVICE_LINK_HISTORY **plk);
#endif

#ifdef	RF_INVALID_RX_PACKET_LOG
	INT32	RFDesc_GetErrorPktIndex (UINT8 index, UINT8 *pmsgindex, UINT8 *pmsgentries, UINT8 *ppktcnt);	
	INT32	RFDesc_GetErrorPkt (UINT8 descrindex, mcpsDataInd_t **phdr, UINT8 *len, UINT8 **pdata, UINT8 *pmsgindex);
	INT32	RFDesc_LogErrorPkt (UINT8 index, mcpsToNwkMessage_t *pMsgIn);
#endif

extern	INT32	RFDesc_ReleaseDescriptiveEntryIfPipeIsEmpty (UINT8 index);
extern	UINT16	RFDesc_GetIndexToDescriptiveTableDevicesExceptForGivenStates (UINT8 *pindextable, UINT8 *plinkstate, UINT8 linkstatelen);
#ifndef	RF_NETWORK_MASTER_DEVICE
extern  void    RFDesc_ReleaseEntryInRoamingDescriptiveTable (UINT8 index);
extern  BOOL	RFDesc_GetIndexToRoamingDescriptiveTableByUID (UINT8 *puid, UINT8 *pindextable);
extern  UINT16	RFDesc_CreateEntryInRoamingDescriptiveTable (UINT8 *pdsindex, UINT8 *puid, UINT16 panid, UINT8 addrmode, UINT8 rxsequence);
#endif

extern  BOOL	RFDesc_RoamingDescriptiveTableIsEmpty(void);

#ifdef  __cplusplus
}
#endif



#endif
/**/
